	 function h = MF_NOTCH_FIR(wnT, wT, Amax)
	 
	 % 	Computes the impulse response of a maximally flat,
	 %	symmetric FIR filter with a notch at wnT. The width 
	 %	of the notch is wT at Amax (dB).
	 
	 %	Autors: 		P. Zahradnik and M. Vlcek: Fast analytical 
	 %					design algorithm for FIR notch filters, 
	 %					IEEE Trans. Circuits and Systems, Part I, 
	 %					Vol. 51, No. 3, pp. 608-621, March 2004,
	 
	 % Modified by: 	LW 2011-01-23 
	 % Copyright:		by authors 
	 % Version:			1  
	 % Known bugs:		 
	 % Report bugs to:	Wanhammar@gmail.com
	 
	 % Determine minimum degree n
	 x = 1-10^(-0.05*Amax);
	 n = log10(x)/log10(cos(wT/2));	 
	 % Multiplicity of zeros at w = 1 where w = cos(wT)
	 p = floor(n*sin(wnT/2)^2)+1;
	 % Multiplicity of zeros at w = -1 where w = cos(wT)
	 q = floor(n*cos(wnT/2)^2)+1;
	 % Check the actual notch frequency
	 w = (q-p)/(q+p);
	 wnT = acos(w)/pi;
	 disp(['Notch frequency: wnT = ', num2str(wnT),' '])	
	 n = p+q;
	 wT = (pi-2*acos(sqrt(1-x^(2/n))))/pi;
	 disp(['Bandwidth at Amax: wT = ',num2str(wT),' '])	
	 a(n+1) = 0;
	 x = ((p+q)/(2*p))^p;
	 y = ((p+q)/(2*q))^q;
	 a(n) = ((-1)^p)*(2^(-p-q+1))*x*y;	
	 for k = n+1:-1:3
		 a(k-2) = (-(n+k)*a(k)+2*(2*p-n)*a(k-1))/(n+2-k);
	 end
	 a0 = (-(n+2)*a(2)+2*(2*p-n)*a(1))/(2*n);	
	 % Compute the impulse response Type I
	 h(p+q+1) = 1 - a0; 
	 for k = 1:n
		 h(n-k+1) = (-1)^(k-1)*a(k)/2;
		 h(n+k+1) = h(n-k+1);
	 end
	 % 	Delete coefficients that are too small at both 
	 %	ends of the tails of the impulse response
	 while (abs(h(1)) < 10^-8) & (abs(h(end)) < 10^-8)
		 h(end) = []; h(1) = []; 
	 end
	 disp(['Filter order: N = ',num2str(length(h)-1)])
	 	 
